'use strict';
function TaskElementCtrl($scope){
    $scope.setDimensions = function(element){
        element.parent().css('position', 'absolute');
        element.parent().css('left', $scope.element.x + 'px');
        element.parent().css('top', $scope.element.y + 'px');
        element.parent().css('width', $scope.element.width);
        element.parent().css('height', $scope.element.height);
        element.parent().css('z-index', 100);

        element.css('width', $scope.element.width);
        element.css('height', $scope.element.height);
    }
}

viewer.directive('taskElementSprite', function () {
    return {
        restrict: "A"
        ,replace: true
        ,scope: {
            element: "="
        }
        ,controller: TaskElementCtrl
        ,link: function (scope, element, attrs) {
            scope.setDimensions(element);
            element.parent().css('z-index', 200);
            element.parent().css('cursor', 'pointer');
            element.css('background', 'url(/data/' + scope.element.background + ' ) 0 0 no-repeat');

            var parent = element.parent();
            parent.draggable({
                create: function(event, ui){
                    ui.sourceElement = scope.element;
                }
                ,drag: function(event, ui){
                    ui.sourceElement = scope.element;
                    console.log(ui);
                }
            });
        }
    }
});
viewer.directive('taskElementHotarea', function () {
    return {
        restrict: "A"
        ,replace: true
        ,scope: {
            element: "="
        }
        ,controller: TaskElementCtrl
        ,link: function (scope, element, attrs) {
            scope.setDimensions(element)
            element.droppable({
                over: function(event, ui){
                    element.addClass('drop-over');
                }
                ,out: function(event, ui){
                    element.removeClass('drop-over');
                }
                ,drop: function(event, ui){
                    console.log(ui);
                    element.removeClass('drop-over');
                }
            })
        }
    }
});

